function Figure6S2C
% This script recreates plots from Figure 6 - figure supplement 2C:
% basemAb = '5C4'; plots data for 5C4
% basemAb = 'CR9501'; plots data for CR9501
% basemAb = 'ADI14359'; plots data for ADI-14359
% basemAb = 'Motav'; plots data for Motavizumab
% basemAb = 'negcontrol'; plots data for the -IgG control

basemAb = input('Enter the mAb to plot (5C4/CR9501/ADI14359/Motav/negcontrol): ','s')

%==========================================================================
% Load data for swollen and non-swollen ('PBS') samples sorted into bins by
% particle size (measured using F intensity) and plot results
load([basemAb,'_shocked_sorted.mat']);
for q = 1:length(F0)
  f = F0{q}; c = C0{q};
  cf = c./f; 
  [cf,i] = sort(cf); f = f(i);
  Q = length(cf); QL = round(Q/4); QH = round(Q*3/4);
  Fs(q) = median(f); CFs(q) = median(cf);
  plot(log10([median(f) median(f)]),[cf(QL) cf(QH)],'m','LineWidth',10); hold on;
  plot(log10([median(f)]),[median(cf)],'sw','MarkerFaceColor','w');
end

load([basemAb,'_PBS_sorted.mat']);
for q = 1:length(F0)
  f = F0{q}; c = C0{q};
  cf = c./f; 
  [cf,i] = sort(cf); f = f(i);
  Q = length(cf); QL = round(Q/4); QH = round(Q*3/4);
  Fp(q) = median(f); CFp(q) = median(cf);
  plot(log10([median(f) median(f)]),[cf(QL) cf(QH)],'k','LineWidth',10); hold on;
  plot(log10([median(f)]),[median(cf)],'sw','MarkerFaceColor','w');
end
ylabel('C3/F per particle');
xlabel('log_{10}[F intensity per particle]');
title(basemAb)
clear F0 A0 C0

% Plot the fold-increase in C3/F following osmotic swelling:
figure;
plot(log10((Fs+Fp)/2),CFs./CFp,'s');
ylabel('Fold-change in C3/F after swelling');
xlabel('log_{10}[F intensity per particle]');
title(basemAb)
%==========================================================================

%==========================================================================
% Calculate and display p-values for each particle size bin (two-sample t-test):
load([basemAb,'_PBS_sorted.mat']);
Fp = F0; Cp = C0;
load([basemAb,'_shocked_sorted.mat']);
Fs = F0; Cs = C0;
for k = 1:length(F0);
  [h,p(k)] = ttest2(Cp{k}./Fp{k},Cs{k}./Fs{k});
  disp(['p-value for data in bin ',num2str(k),': ',num2str(p(k))]);
end
%==========================================================================